// O-Log REC2020 to ACES AP0 CTL

//define rec2020_to_xyz make_mat3(make_float3(0.6370f, 0.1446f, 0.1689f), make_float3(0.2627f, 0.6780f, 0.0593f), make_float3(0.0f, 0.0281f, 1.0610f))

//define d65_to_d60_cat02 make_mat3(make_float3(1.01174414f, 0.00770577991f, -0.0157216747f), make_float3(0.00555788933f, 1.00153586f,-0.00626219941f), make_float3(-0.000334059457f,-0.00104828776f, 0.927569778f))

//define xyz_to_acesAP0 make_mat3(make_float3(1.0498110175f, 0.0f, -0.0001f), make_float3(-0.4959030231f, 1.3733130458f, 0.0982400361f), make_float3(0.0f, 0.0f, 0.9912520182f))

// OLog Curve Encoding Function
float relativeSceneLinearToNormalizedOLog( float x) {
	return (0.139f * log(x * 16+ 0.019f)/log(_expf(1)) + 0.614f);
}

// OLog Curve Decoding Function
float normalizedOLogToRelativeSceneLinear( float x) {
	return (_expf((x - 0.614f)/0.139f) - 0.019f)/16.0f*7.37235f;;
}

void OLogToACES
 ( 	input varying float rIn,
	input varying float gIn,
	input varying float bIn,
	input varying float aIn,
	output varying float rOut,
	output varying float gOut,
	output varying float bOut,
	output varying float aOut)
{

float r_lin = normalizedOLogToRelativeSceneLinear(rIn);
float g_lin = normalizedOLogToRelativeSceneLinear(gIn);
float b_lin = normalizedOLogToRelativeSceneLinear(bIn);

float x_D65 = r_lin * 0.6370 + g_lin * 0.1446 + b_lin * 0.1689;
float y_D65 = r_lin * 0.2627 + g_lin * 0.6780 + b_lin * 0.0593;
float z_D65 = r_lin * 0.0 + g_lin * 0.0281 + b_lin * 1.0610;

float x_D60 = x_D65 * 1.01174414 + y_D65 * 0.00770577991 + z_D65 * -0.0157216747;
float y_D60 = x_D65 * 0.00555788933 + y_D65 * 1.00153586 + z_D65 * -0.00626219941;
float z_D60 = x_D65 * -0.000334059457 + y_D65 * -0.00104828776 + z_D65 * 0.927569778;

rOut = x_D60 * 1.0498110175 + y_D60 * 0.0 + z_D60 * -0.0001;
gOut = x_D60 * -0.4959030231 + y_D60 * 1.3733130458 + z_D60 * 0.0982400361;
bOut = x_D60 * 0.0 + y_D60 * 0.0 + z_D60 * 0.9912520182;
aOut = 1.0;

}

